% path/filename: extrudeFracturePlanes.m
% Purpose: Extrudes 2D line segments into 3D fracture planes based on depth

function fracplanes = extrudeFracturePlanes(fractureLines,fractureAperture, depth)
    numFractures = size(fractureLines, 1);
    %fracplanes = struct('points', [], 'numpoints', [], 'center', [], 'size', [], 'TriangleList', [], 'exclusionzone', [], 'perm', [], 'poro', [], 'aperture', [], 'area', [], 'SetID', [], 'twinsetID', []);
    fracplanes = struct('points', [], 'numpoints', [], 'center', [], 'normal',[], 'size', [],'perm', [], 'poro', [], 'aperture', [],'area', [],  'SetID', [], 'twinsetID', [] );

    orientations = zeros(numFractures, 1);
    setID = zeros(numFractures, 1);
    
    % Calculate orientation angles for all fractures
    for i = 1:numFractures
        orientations(i) = calculateOrientationAngle(fractureLines(i, 1), fractureLines(i, 2), fractureLines(i, 3), fractureLines(i, 4));
    end

    for i = 1:numFractures
        if 60 < orientations(i) && orientations(i) < 120
            setID(i) = 1;
        else
            setID(i) = 2;
        end
    end

    for i = 1:numFractures
        x1 = fractureLines(i, 1);
        y1 = fractureLines(i, 2);
        x2 = fractureLines(i, 3);
        y2 = fractureLines(i, 4);

        % Creating 3D points by extruding the line segment along z-axis
        points3D = [x1 y1 0; x2 y2 0; x2 y2 depth; x1 y1 depth];
        [center, area] =calculateFractureProperties(points3D);

        % Calculate the length of the line segment (size of the fracture)
        sizeLength = sqrt((x2 - x1)^2 + (y2 - y1)^2);

        % Assuming other properties (e.g., normal, size, etc.) will be set later
        fracplanes(i).points = points3D;
        fracplanes(i).normal=calculateNormalToPlane(points3D);
        fracplanes(i).numpoints = 4; % since it's a rectangular plane
        fracplanes(i).SetID = setID(i);
        fracplanes(i).poro = 1;
        fracplanes(i).aperture= fractureAperture(i);
        fracplanes(i).perm= (fractureAperture(i)^2)/12; %((0.001^2)/12)/ (9.869233 * 10^-16);
        fracplanes(i).twinsetID=i;
        fracplanes(i).size = sizeLength; 
        fracplanes(i).center = center;
        fracplanes(i).area=area;

        % ... other properties to be set
    end
end